 ; Ŀ
 ;   Ca - continue an existing line or arc.                                
 ;   Copyright 2004, 2006, 2008 by Rocket Software Ltd.                    
 ;   Signs of a good program:                                              
 ;   1. Why did I never think of that before?                              
 ;   2. I don't care what anyone else thinks...                            
 ;   3. I can't believe this actually works.                               
 ; 

 ; Ŀ
 ;   Subroutine Ha - find the midpoint of an arc.  And other data.         
 ;   Copyright 1994 by Rocket Software Ltd.                                
 ;   Takes one argument, an arc entity name.                               
 ;   Returns a list: ((start point, midpoint, endpoint, chord midpoint)    
 ;                    (start angle, mid angle, end angle)).                
 ; 
 (DEFUN HA (enam / arcent pa rad stangl endang midang midd start endpt chmidx
                                                    chmidy chmid height leng)
  (setq arcent (entget enam))
 ; Ŀ
 ;   Extract the arc entity data.                                          
 ; 
  (setq pa (cdr (assoc 10 arcent)))
  (setq rad (cdr (assoc 40 arcent)))
  (setq stangl (cdr (assoc 50 arcent)))
  (setq endang (cdr (assoc 51 arcent)))
 ; Ŀ
 ;   Find the centre to midpoint angle.                                    
 ; 
  (setq midang (+ (/ (- endang stangl) 2) stangl))
  (if (> stangl endang)
      (setq midang (+ midang pi)))
 ; Ŀ
 ;   Get the midpoint.                                                     
 ; 
  (setq midd (polar pa midang rad))
 ; Ŀ
 ;   Now find the chord midpoint.                                          
 ; 
  (setq start (polar pa stangl rad))
  (setq endpt (polar pa endang rad))
  (setq chmidx (/ (+ (car start) (car endpt)) 2))
  (setq chmidy (/ (+ (cadr start) (cadr endpt)) 2))
  (setq chmid (list chmidx chmidy))
;  (setq height (distance chmid midd))   ; chord height - not currently used
;  (setq leng (distance start endpt))    ; chord length - not currentle used
 (list (list start midd endpt chmid) (list stangl midang endang)))
 ; Ŀ
 ;   Subroutine Ha end.                                                    
 ; 

 ; Ŀ
 ;   Ca.                                                                   
 ; 
 (DEFUN C:CA (/ enampt enam entt ppta plist pa pmid pb)
  (setvar "cmdecho" 0)
  (setvar "osmode" 0)
  (if (setq enampt (entsel "Arc or Line to Continue: "))
      (progn
           (setq enam (car enampt))
           (setq ppta (cadr enampt))
           (setq entt (entget enam))
           (setq etype (cdr (assoc 0 entt)))))
 ; Ŀ
 ;   If no entity was selected and the last entity created was an arc or   
 ;   a line, try to continue an arc from it.                               
 ; 
  (cond ((and (null enampt)
              (getvar "lastangle"))
         (command ".arc" ""))
 ; Ŀ
 ;   We are continuing an arc.                                             
 ; 
        ((= etype "ARC")
         (setq plist (ha enam))
         (setq plist (reverse (cdr (reverse (car plist)))))
         (setq pa (car plist))
         (setq pmid (cadr plist))
         (setq pb (caddr plist))
         (if (> (distance pa ppta) (distance pb ppta))
             (command ".arc" pa pmid pb)
             (command ".arc" pb pmid pa))
         (entdel (entlast))
         (command ".arc" ""))
 ; Ŀ
 ;   We are continuing a line.                                             
 ; 
        ((= etype "LINE")
         (setq pa (cdr (assoc 10 entt)))
         (setq pb (cdr (assoc 11 entt)))
         (if (> (distance pa ppta) (distance pb ppta))
             (command ".line" pa pb "")
             (command ".line" pb pa ""))
         (entdel (entlast))
         (command ".arc" ""))
 ; Ŀ
 ;   We can't continue.                                                    
 ; 
        (t (prompt "No continuable entity selected.")))
 (princ))